﻿#language C++Script

// BaseTranslator.cpp

// Jeff Godfrey, 05-Sep-2011

// Converts values between Decimal, Hex, and Binary

// Base conversion algorithm from:
// http://www.oocities.org/athens/acropolis/2692/computer/numericbase.html

TForm frmMain;
TButton btnOK;
TLabel lblDecimal; TEdit entDecimal;
TLabel lblHex; TEdit entHex;
TLabel lblBinary; TEdit entBinary;

string charList = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

void BuildUI()
{
   int col1 = 10;
   int col2 = 85;
   int rowSpace = 27;
   int top = 12;
   int frmWidth = 450;
   int frmHeight = 175;
   int entWidth = frmWidth - 150;

   frmMain = new TForm(nil);
   frmMain.Caption = "Numeric Base Translator";
   frmMain.BorderStyle = bsDialog;
   frmMain.Position = poScreenCenter;
   frmMain.Width = frmWidth;
   frmMain.Height = frmHeight;

   lblDecimal = new TLabel(frmMain);
   lblDecimal.Parent = frmMain;
   lblDecimal.Left = col1;
   lblDecimal.Top = top;
   lblDecimal.Caption = "Decimal:";

   entDecimal = new TEdit(frmMain);
   entDecimal.Name = "decimal";
   entDecimal.Text = "";
   entDecimal.Parent = frmMain;
   entDecimal.Width = entWidth;
   entDecimal.Left = col2;
   entDecimal.Top = top - 4;
   entDecimal.OnKeyPress = &KeyPress;
   entDecimal.OnKeyUp = &UpdateAll;

   top += rowSpace;

   lblHex = new TLabel(frmMain);
   lblHex.Parent = frmMain;
   lblHex.Left = col1;
   lblHex.Top = top;
   lblHex.Caption = "HexaDecimal:";

   entHex = new TEdit(frmMain);
   entHex.Name = "hex";
   entHex.Text = "";
   entHex.Parent = frmMain;
   entHex.Width = entWidth;
   entHex.Left = col2;
   entHex.Top = top - 4;
   entHex.OnKeyPress = &KeyPress;
   entHex.OnKeyUp = &UpdateAll;

   top += rowSpace;

   lblBinary = new TLabel(frmMain);
   lblBinary.Parent = frmMain;
   lblBinary.Left = col1;
   lblBinary.Top = top;
   lblBinary.Caption = "Binary:";

   entBinary = new TEdit(frmMain);
   entBinary.Name = "binary";
   entBinary.Text = "";
   entBinary.Parent = frmMain;
   entBinary.Width = entWidth;
   entBinary.Left = col2;
   entBinary.Top = top - 4;
   entBinary.OnKeyPress = &KeyPress;
   entBinary.OnKeyUp = &UpdateAll;

   btnOK = new TButton(frmMain);
   btnOK.Parent = frmMain;
   btnOK.Width = 80;
   btnOK.Left = frmWidth - btnOK.Width - 15;
   btnOK.Top = frmHeight - 60;
   btnOK.Caption = "OK";
   btnOK.OnClick = &ButtonClick;
}

void ButtonClick(TButton Sender)
{
   frmMain.ModalResult = mrOK;
}

void KeyPress(TObject sender, char key)
{
   int base = 10;
   string name = TEdit(sender).Name;
   if (name == "decimal")     { base = 10; }
   else if (name == "hex")    { base = 16; }
   else if (name == "binary") { base = 2; }
   else { ShowMessage("Unknown control -> " + name); }
   string validKeys = Copy(charList, 1, base);
   if ((key != #8) && (ScriptUtils.PosFrom(key, validKeys, 1) == 0)) { key = #0; }
}

void UpdateAll(TObject sender, WORD key)
{
   try
   {
      string name = TEdit(sender).Name;
      if (name == "decimal")
      {
         entBinary.Text = Base2Base(entDecimal.Text, 10, 2);
         entHex.Text = Base2Base(entDecimal.Text, 10, 16);
      }
      else if (name == "hex")
      {
         entDecimal.Text = Base2Base(entHex.Text, 16, 10);
         entBinary.Text = Base2Base(entHex.Text, 16, 2);
      }
      else if (name == "binary")
      {
         entDecimal.Text = Base2Base(entBinary.Text, 2, 10);
         entHex.Text = Base2Base(entBinary.Text, 2, 16);
      }
      else
      {
         ShowMessage("Unknown control -> " + name);
      }
   }
   except
   {
      ShowMessage("Unable to convert specified value!");
      clearAll();
   }
}

string Base2Base(string inString, int baseIn, int baseOut)
{
   int maxBase = Length(charList);
   if ((baseIn > maxBase) || (baseOut > maxBase))
   {
      return "N/A";
   }

   if (inString == "0") { return "0"; }

   string outputVal = "";

   try
   {

      // Convert the passed numeric string to a base 10 number
      int inputLength = Length(inString);
      int decimalVal = 0;
      for (int j = 1; j <= inputLength; j++)
      {
         for (int k = 1; k <= baseIn; k++)
         {
            if (Copy(inString, j, 1) == Copy(charList, k, 1))
            {
               decimalVal = decimalVal + int((k - 1) * Power(baseIn, (inputLength - j)) + 0.5);
            }
         }
      }

      // Convert the base 10 value to the required output base
      while (decimalVal > 0)
      {
         int x = int((((decimalVal/baseOut) - int(decimalVal/baseOut)) * baseOut) + 1.5);
         outputVal = Copy(charList, x, 1) + outputVal;
         decimalVal = int(decimalVal/baseOut);
      }
   }
   finally
   {
      if ((Length(inString) > 0) && (Length(outputVal) == 0)) { outputVal = "ERROR"; }
      return outputVal;
   }
}

void ClearAll()
{
   entDecimal.Text = "";
   entHex.Text = "";
   entBinary.Text = "";
}

// Raises x to the power of y
float Power(float x, float y)
{
   return Exp(y * Ln(x));
}

{
   BuildUI();
   frmMain.ShowModal;
   frmMain.Free;
}



